<?php
/**
 *
  Template Name: Faq Landing Template
 *
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage Paper_Plane
 * @since PaperPlane 1.0
 */
$page_id = get_the_ID();
$parent_page_id = wp_get_post_parent_id($page_id);

$location = get_the_terms($parent_page_id, 'locations');
$location_id = '';
foreach ($location as $value) {
  $location_id = $value->term_id;
}

$GLOBALS['location'] = $location;
$GLOBALS['location_id'] = $location_id;

$position = 1;
$destination_obj = get_destination_by_taxanomy('locations', $GLOBALS['location'][0]->term_id);
$hotel_name = '';
if ($destination_obj->have_posts()) {

  while ($destination_obj->have_posts()) {

    $destination_obj->the_post();
    $hotel_name = get_post_meta(get_the_id(), 'name', true);
  }
}
wp_reset_postdata();
$itemList = [];
$itemList[0]['@type'] = 'ListItem';
$itemList[0]['position'] = $position;
$itemList[0]['item']['@id'] = site_url() . '/';
$itemList[0]['item']['name'] = 'Home';

$itemList[1]['@type'] = 'ListItem';
$itemList[1]['position'] = $position + 1;
$itemList[1]['item']['@id'] = site_url() . '/' . 'the-lalit-' . $GLOBALS['location'][0]->slug . '/';
$itemList[1]['item']['name'] = $hotel_name;

$itemList[2]['@type'] = 'ListItem';
$itemList[2]['position'] = $position + 2;
$itemList[2]['item']['@id'] = site_url() . $_SERVER['REQUEST_URI'];
$itemList[2]['item']['name'] = get_the_title(get_the_id());
?>
<!DOCTYPE html>
<html lang="en-IN">
    <head>
        <?php wp_head(); ?>
        <?php get_template_part('includes/css', 'js'); ?>
        <script type="application/ld+json">
            {
            "@context": "http://schema.org",
            "@type": "BreadcrumbList",
            "itemListElement": <?php echo json_encode($itemList); ?>
            }
        </script>
        <link rel="stylesheet" href="<?= get_stylesheet_directory_uri().'/custom.css' ?>">
        <!--<link rel="stylesheet" href="https://www.thelalit.com/faq.css">-->
    </head>
    <body <?php body_class('global-page'); ?>>
        <div class="main-wrap">
            <?php get_header(); ?>
            <?php while (have_posts()) : the_post(); ?>
              <div class="content-section">
                  <div class="container align-center small-banner-sec js_fade" style="background-image: url('/wp-content/themes/lalit/images/faq.jpg'); opacity: 1;background-size: cover;">
                      <div class="row">
                          <div class="banner-content">
                              <h1 class="main-title text-shadow">Frequently Asked Questions</h1>
                          </div>
                      </div>
                  </div>
                  <?php
                  /* $page_title = get_the_title();

                    if ($page_title != 'Privacy Policy') {
                    ?>
                    <div class="banner-slider align-center">
                    <div id="banner-slider" class="flexslider">
                    <ul class="slides">
                    <li>
                    <img src="<?php echo home_url(); ?>/wp-content/themes/lalit/images/About-us-1.jpg" />
                    </li>
                    <li>
                    <img src="<?php echo home_url(); ?>/wp-content/themes/lalit/images/About-us-2.jpeg" />
                    </li>
                    </ul>
                    </div>
                    </div>
                    <?php
                    } */
                  ?>
                  <div class="page-con">
                      <div class="container section-space intro-text align-center">
                          <div class="row">
                              <div class="seperator"></div>
                              <h1 class="sec-title">Frequently Asked Questions</h1>
                              <div class="col col10 align-content-center ">
                                  <!--<p>How can we help you?</p>-->
                              </div>
                          </div>
                          <div class="container"> 
                              <div class="faq_7" unique-script-id="w-w-dm-id">
                                  <div class="responsive-container-block">
                                      <div class="responsive-cell-block wk-tab-12 wk-mobile-12 wk-desk-12 wk-ipadp-12 faq-dropdown-bg" id="imiw">
                                          <?php echo get_the_content();?>
<!--                                          <div class="container" id="iwk5t">
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          1.	Why is The LaLiT Chandigarh regarded as one of the best 5-star luxury hotels in Chandigarh?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The LaLiT Chandigarh is a premier 5-star luxury hotel, seamlessly blending
                                                              elegant architecture, modern sophistication, and impeccable hospitality.
                                                              Nestled at the foothills of the Shivalik range, this iconic hotel offers lavish
                                                              accommodations, gourmet dining, a rejuvenating spa, and state-of-the-
                                                              art business and event facilities. Whether you are here for business,
                                                              leisure, or a grand celebration, The LaLiT Chandigarh promises an
                                                              unmatched experience of comfort, style, and personalized service.
                                                          </p> 
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          2.	Where is The LaLiT Chandigarh located?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>Strategically situated in Rajiv Gandhi IT Park, The LaLiT Chandigarh enjoys
                                                              prime connectivity to both corporate hubs and major tourist attractions.
                                                              It is:
                                                          </p>
                                                          <ul>
                                                              <li>8 km (15-minute drive) from Chandigarh International Airport.</li>
                                                              <li>6 km (12-minute drive) from Sector 17 – Chandigarh’s commercial
                                                                  and shopping district.</li>
                                                              <li>Close to key landmarks like Sukhna Lake, Rock Garden, and
                                                                  Elante Mall.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          3.	What types of accommodations are available at this luxury hotel?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The hotel’s lavishly appointed rooms and suites redefine sophistication
                                                              and relaxation, offering panoramic views of the Shivalik Hills and the
                                                              cityscape. Options include:
                                                          </p>
                                                          <ul> 
                                                              <li>Deluxe Rooms – Stylish and contemporary, with modern amenities.</li>
                                                              <li>Luxury Suites – Offering spacious living areas, premium
                                                                  furnishings, and exclusive privileges.</li>
                                                              <li>The LaLiT Legacy Suite (Presidential Suite) – The epitome of
                                                                  grandeur and opulence, featuring expansive interiors,
                                                                  personalized butler service, and stunning skyline views.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          4.	What are the best dining options at The LaLiT Chandigarh?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The LaLiT Chandigarh offers a diverse culinary experience, with an
                                                              emphasis on authentic flavors, fresh ingredients, and world-class
                                                              service. Signature dining venues include:
                                                          </p>
                                                          <ul>
                                                              <li>Baluchi – The hotel’s signature Pan-Indian fine-dining restaurant,
                                                                  renowned for its traditional Awadhi and North-Western Frontier
                                                                  cuisine.</li>
                                                              <li>24/7 Restaurant – A multi-cuisine all-day dining experience, serving
                                                                  both international and local favorites.</li>
                                                              <li>Le Petit Café – A charming café offering gourmet coffees,
                                                                  artisanal teas, and delectable pastries.</li>
                                                              <li>The Circle Bar – A sophisticated lounge bar featuring handcrafted
                                                                  cocktails, premium spirits, and an elegant ambiance.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          5.	What exclusive wellness and spa services does the hotel offer?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The Spiceology Spa at The LaLiT Chandigarh is a haven of tranquility
                                                              and indulgence, offering a range of luxury wellness treatments, including:
                                                          </p>
                                                          <ul>
                                                              <li>Ayurvedic therapies and holistic healing rituals.</li>
                                                              <li>Signature deep tissue and aromatherapy massages for complete
                                                                  rejuvenation..</li>
                                                              <li>Luxury facials, detoxifying body wraps, and beauty treatments.</li>
                                                              <li>A state-of-the-art fitness center equipped with modern workout
                                                                  facilities.</li>
                                                              <li>Personalized yoga and meditation sessions for mental and physical
                                                                  well-being.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          6.	What unique experiences can guests enjoy at this luxury hotel?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The LaLiT Chandigarh curates exceptional experiences, ensuring guests
                                                              enjoy both relaxation and cultural immersion:
                                                          </p>
                                                          <ul>
                                                              <li>Heritage Walks &amp; City Tours – Explore the rich history and
                                                                  architectural brilliance of Chandigarh’s iconic landmarks.</li>
                                                              <li>Sunset Evenings at Sukhna Lake – Experience the serene beauty
                                                                  of Chandigarh’s most scenic location.</li>
                                                              <li>Private Dining Experiences – Enjoy exquisite meals under the
                                                                  stars, specially curated by the hotel’s renowned chefs.</li>
                                                              <li>Personalized Shopping Assistance – Indulge in a guided luxury
                                                                  shopping spree at Elante Mall or Sector 17 Plaza.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          7.	Does The LaLiT Chandigarh offer wedding and event facilities?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Yes! The LaLiT Chandigarh is one of the most sought-after wedding and
                                                              event venues in the city, featuring:
                                                          </p>
                                                          <ul>
                                                              <li>Lavish banquet halls and grand outdoor venues with stunning
                                                                  decor.</li>
                                                              <li>Expert wedding planners to curate your dream wedding.</li>
                                                              <li>Customized gourmet catering options.</li>
                                                              <li>Cutting-edge business and conference facilities, ideal for corporate
                                                                  events.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          8.	Which are the top attractions near The LaLiT Chandigarh?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Guests staying at this luxury hotel in Chandigarh have easy access to:
                                                          </p>
                                                          <ul>
                                                              <li>Sukhna Lake (6 km | 12-minute drive | Taxi, Private Car)</li>
                                                              <li>Rock Garden (5.5 km | 10-minute drive | Taxi, Private Car)</li>
                                                              <li>Elante Mall (7 km | 15-minute drive | Taxi, Private Car)</li>
                                                              <li>Rose Garden (6.5 km | 12-minute drive | Taxi, Private Car)</li>
                                                              <li>Pinjore Gardens (21 km | 40-minute drive | Private Car)</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          9.	Does the hotel provide airport transfers and concierge services?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Absolutely! The LaLiT Chandigarh offers luxury airport transfers from
                                                              Chandigarh International Airport, including:
                                                          </p>
                                                          <ul>
                                                              <li>Chauffeur-driven private car services.</li>
                                                              <li>Personalized sightseeing tours and curated itineraries.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          10.	How can I book my stay at this 5-star luxury hotel in Chandigarh?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Guests can book their stay directly through The LaLiT Chandigarh’s official
                                                              website for exclusive privileges, including:
                                                          </p>
                                                          <ul>
                                                              <li>Early booking discounts and bespoke luxury packages.</li>
                                                              <li>Personalized concierge assistance for a tailored stay.</li>
                                                              <li>Book your stay today and discover Chandigarh’s most exquisite luxury
                                                                  retreat!</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>-->
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
              <!--content-section-->
            <?php endwhile; ?>
            <?php get_footer(); ?>
        </div><!-- main-wrap -->
        <script type="text/javascript">
          jQuery(document).ready(function () {
              jQuery(".video-thumb").on('touchstart click', function () {
                  var data = jQuery(this).next(".video-block").attr("data");
                  jQuery(this).next(".video-block").attr("src", data);
                  jQuery(this).css("display", "none");
                  jQuery(this).next(".video-block").css("display", "block");

              });
          });
        </script>
        <script>
          jQuery(document).ready(function () {
              jQuery('.faq-question-container').on('click', function () {
                  jQuery(this).parent().toggleClass('active', 1000 ,'easeOutSine');
              })
          });
        </script>
    <!--<script src="https://www.thelalit.com/faq.js"></script>-->
    </body>

</html>