<?php
/**
 *
  Template Name: Faq Udaipur Template
 *
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage Paper_Plane
 * @since PaperPlane 1.0
 */
$page_id = get_the_ID();
$parent_page_id = wp_get_post_parent_id($page_id);

$location = get_the_terms($parent_page_id, 'locations');
$location_id = '';
foreach ($location as $value) {
  $location_id = $value->term_id;
}

$GLOBALS['location'] = $location;
$GLOBALS['location_id'] = $location_id;

$position = 1;
$destination_obj = get_destination_by_taxanomy('locations', $GLOBALS['location'][0]->term_id);
$hotel_name = '';
if ($destination_obj->have_posts()) {

  while ($destination_obj->have_posts()) {

    $destination_obj->the_post();
    $hotel_name = get_post_meta(get_the_id(), 'name', true);
  }
}
wp_reset_postdata();
$itemList = [];
$itemList[0]['@type'] = 'ListItem';
$itemList[0]['position'] = $position;
$itemList[0]['item']['@id'] = site_url() . '/';
$itemList[0]['item']['name'] = 'Home';

$itemList[1]['@type'] = 'ListItem';
$itemList[1]['position'] = $position + 1;
$itemList[1]['item']['@id'] = site_url() . '/' . 'the-lalit-' . $GLOBALS['location'][0]->slug . '/';
$itemList[1]['item']['name'] = $hotel_name;

$itemList[2]['@type'] = 'ListItem';
$itemList[2]['position'] = $position + 2;
$itemList[2]['item']['@id'] = site_url() . $_SERVER['REQUEST_URI'];
$itemList[2]['item']['name'] = get_the_title(get_the_id());
?>
<!DOCTYPE html>
<html lang="en-IN">
    <head>
        <?php wp_head(); ?>
        <?php get_template_part('includes/css', 'js'); ?>
        <script type="application/ld+json">
            {
            "@context": "http://schema.org",
            "@type": "BreadcrumbList",
            "itemListElement": <?php echo json_encode($itemList); ?>
            }
        </script>
       <link rel="stylesheet" href="<?= get_stylesheet_directory_uri().'/custom.css' ?>">
    </head>
    <body <?php body_class('global-page'); ?>>
        <div class="main-wrap">
            <?php get_header(); ?>
            <?php while (have_posts()) : the_post(); ?>
              <div class="content-section">
                  <div class="container align-center small-banner-sec js_fade" style="background-image: url('/wp-content/themes/lalit/images/faq.jpg'); opacity: 1;background-size: cover;">
                      <div class="row">
                          <div class="banner-content">
                              <h1 class="main-title text-shadow">Frequently Asked Questions</h1>
                          </div>
                      </div>
                  </div>
                  <?php
                  /* $page_title = get_the_title();

                    if ($page_title != 'Privacy Policy') {
                    ?>
                    <div class="banner-slider align-center">
                    <div id="banner-slider" class="flexslider">
                    <ul class="slides">
                    <li>
                    <img src="<?php echo home_url(); ?>/wp-content/themes/lalit/images/About-us-1.jpg" />
                    </li>
                    <li>
                    <img src="<?php echo home_url(); ?>/wp-content/themes/lalit/images/About-us-2.jpeg" />
                    </li>
                    </ul>
                    </div>
                    </div>
                    <?php
                    } */
                  ?>
                  <div class="page-con">
                      <?php //the_content(); ?>
                      <div class="container section-space intro-text align-center">
                          <div class="row">
                              <div class="seperator"></div>
                              <h1 class="sec-title">Frequently Asked Questions</h1>
                              <div class="col col10 align-content-center ">
                                  <!--<p>How can we help you?</p>-->
                              </div>
                          </div>
                          <div class="container">
                              <div class="faq_7" unique-script-id="w-w-dm-id">
                                  <div class="responsive-container-block">
                                      <div class="responsive-cell-block wk-tab-12 wk-mobile-12 wk-desk-12 wk-ipadp-12 faq-dropdown-bg" id="imiw">
                                          <?php echo get_the_content();?>
<!--                                          <div class="container" id="iwk5t">
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          1.	Why is The LaLiT Laxmi Vilas Palace Udaipur regarded as one of the best 5-
                                                          star luxury hotels in Udaipur?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Perched majestically on a hilltop overlooking the pristine Fateh Sagar Lake, The
                                                              LaLiT Laxmi Vilas Palace Udaipur is a royal heritage hotel that embodies the
                                                              grandeur of Rajasthan’s regal past while offering modern 5-star luxury.
                                                              Originally built in 1911 by Maharana Fateh Singh, this architectural
                                                              masterpiece boasts opulent suites, world-class hospitality, gourmet dining,
                                                              and curated cultural experiences, making it one of the best luxury hotels in
                                                              Udaipur for travelers seeking elegance, exclusivity, and an unforgettable stay.
                                                          </p> 
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          2.	Where is The LaLiT Laxmi Vilas Palace Udaipur located?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>This iconic 5-star heritage hotel is beautifully located on a scenic hilltop along
                                                              Fateh Sagar Lake, offering breathtaking panoramic views of the Aravalli Hills
                                                              and Udaipur’s royal cityscape. The hotel’s prime location ensures that guests
                                                              are within easy reach of Udaipur’s top attractions, such as City Palace, Lake
                                                              Pichola, and Sajjangarh Fort, making it a perfect retreat for luxury seekers.
                                                          </p>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          3.	What types of accommodations are available at this luxury hotel?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The accommodations at The LaLiT Laxmi Vilas Palace Udaipur redefine
                                                              heritage luxury, offering guests an indulgent blend of Rajasthani royal charm
                                                              and contemporary comfort. Each room and suite is thoughtfully designed to
                                                              immerse guests in the elegance of a bygone era, featuring intricate
                                                              woodwork, vintage decor, and plush modern amenities. Options include:
                                                          </p>
                                                          <ul> 
                                                              <li>Palace Rooms – Perfect for guests seeking classic luxury with
                                                                  picturesque views.</li>
                                                              <li>Heritage Suites – Elegantly designed with expansive living spaces and
                                                                  regal furnishings.</li>
                                                              <li>Maharana Suite – The epitome of royal indulgence, offering a private
                                                                  terrace with breathtaking lake views, a grand bedroom, and
                                                                  dedicated butler service.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          4.	What are the finest dining options at this 5-star luxury hotel in Udaipur?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The LaLiT Laxmi Vilas Palace Udaipur offers a gastronomic experience fit
                                                              for royalty, featuring the finest local and global cuisines prepared by expert
                                                              chefs in an ambiance of unmatched grandeur. Dining options include:
                                                          </p>
                                                          <ul>
                                                              <li>Aangan – A signature fine dining experience with authentic Rajasthani
                                                                  flavors, complemented by mesmerizing views of Fateh Sagar Lake.</li>
                                                              <li>Padmini – A multi-cuisine all-day dining restaurant, offering a fusion of
                                                                  Indian and international delicacies.</li>
                                                              <li>The Garden Grill – A romantic al fresco dining experience, featuring
                                                                  succulent grilled specialties under a starlit sky.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          5.	What exclusive wellness and spa services are available at the hotel?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Guests can embark on a holistic wellness journey at the Spiceology Spa,
                                                              which offers a curated selection of rejuvenating treatments inspired by
                                                              ancient Ayurvedic and contemporary healing techniques. Signature offerings
                                                              include:
                                                          </p>
                                                          <ul>
                                                              <li>Traditional Ayurvedic therapies to restore balance and harmony.</li>
                                                              <li>Deep tissue and Swedish massages for complete relaxation.</li>
                                                              <li>Exclusive wellness rituals and beauty therapies for a luxurious spa
                                                                  experience.</li>
                                                              <p>Additionally, the hotel features a fully equipped fitness center and
                                                                  serene yoga sessions amidst the picturesque palace gardens.</p>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          6.	What unique experiences and activities can guests enjoy at this 5-star
                                                          hotel?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              The LaLiT Laxmi Vilas Palace Udaipur offers bespoke experiences that provide
                                                              guests with an authentic taste of Rajasthan’s cultural and royal heritage,
                                                              including:
                                                          </p>
                                                          <ul>
                                                              <li>Heritage Walks – Explore the rich history and regal architecture of the
                                                                  palace with a guided tour.</li>
                                                              <li>Live Cultural Performances – Experience traditional Rajasthani folk
                                                                  music and dance, including the mesmerizing Kathputli (puppet) dance,
                                                                  a centuries-old storytelling art form unique to Rajasthan.</li>
                                                              <li>Sunset Boat Rides on Fateh Sagar Lake – Witness the golden hues of
                                                                  Udaipur’s sunset as you glide across the tranquil waters, with the
                                                                  majestic Aravalli Hills and grand palaces creating a breathtaking
                                                                  backdrop.</li>
                                                              <li>Private Royal Dining Experiences – Savor an exclusive candlelit
                                                                  dinner under the stars, set against the enchanting views of Fateh Sagar
                                                                  Lake and Udaipur’s skyline, with curated gourmet delicacies crafted
                                                                  by expert chefs.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          7.	Is The LaLiT Laxmi Vilas Palace Udaipur a preferred wedding and event
                                                          destination?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Absolutely! Recognized as one of the most sought-after destination wedding
                                                              venues in Udaipur, the palace offers a storybook setting for regal
                                                              celebrations. The hotel’s stunning venues and expert event planning
                                                              services make it ideal for weddings, corporate gatherings, and milestone
                                                              celebrations. Highlights include:
                                                          </p>
                                                          <ul>
                                                              <li>Enchanting outdoor wedding venues with panoramic views.</li>
                                                              <li>Lavish banquet halls and heritage courtyards for grand celebrations.</li>
                                                              <li>Custom wedding planning, curated gourmet menus, and luxury
                                                                  bridal suites.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          8.	Which are the top nearby attractions to explore from this luxury hotel?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Staying at this 5-star heritage hotel in Udaipur provides easy access to some
                                                              of the city’s most iconic landmarks, including:
                                                          </p>
                                                          <ul>
                                                              <li>City Palace (4 km | 10-minute drive | Taxi, Private Car)</li>
                                                              <li>Lake Pichola (5 km | 12-minute drive | Boat Ride, Taxi)</li>
                                                              <li>Jagdish Temple (4 km | 10-minute drive | Taxi, Tuk-Tuk)</li>
                                                              <li>Saheliyon Ki Bari (2 km | 5-minute drive | Taxi, Tuk-Tuk)</li>
                                                              <li>Monsoon Palace (Sajjangarh Fort) (8 km | 20-minute drive | Private Car)</li>
                                                              <li>Bagore Ki Haveli (5 km | 12-minute drive | Taxi, Tuk-Tuk)</li>
                                                              <li>Shilpgram (Rajasthani Handicraft Village) (4 km | 10-minute drive | Taxi,
                                                                  Private Car)</li>
                                                              <li>Fateh Prakash Palace Museum (3 km | 8-minute drive | Taxi, Tuk-Tuk)</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          9.	Does The LaLiT Laxmi Vilas Palace Udaipur provide airport transfers and
                                                          concierge services?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Yes! The hotel offers luxury airport transfers from Maharana Pratap Airport
                                                              (27 km | 40-minute drive). Guests can choose from:
                                                          </p>
                                                          <ul>
                                                              <li>Private luxury car service with a chauffeur.</li>
                                                              <li>Airport shuttle service upon request.</li>
                                                              <li>Concierge-assisted personalized sightseeing tours.</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="faq">
                                                  <span class="faq-question-container">
                                                      <p class="text-blk faq-questions">
                                                          10.	How can I book my stay at this 5-star luxury hotel in Udaipur?
                                                      </p>
                                                      <img class="openimg" src="https://workik-widget-assets.s3.amazonaws.com/widget-assets/images/arrow.svg">
                                                  </span>
                                                  <div class="answer-box">
                                                      <div class="text-blk faq-answer">
                                                          <p>
                                                              Guests can book their stay directly through The LaLiT Laxmi Vilas Palace
                                                              Udaipur’s official website or through premium travel partners. Exclusive
                                                              benefits include:
                                                          </p>
                                                          <ul>
                                                              <li>Early booking discounts and tailored luxury packages.</li>
                                                              <li>Personalized itinerary planning for an unmatched experience.</li>
                                                              <li>Book your stay today and immerse yourself in the regal splendor of
                                                                  Rajasthan’s most luxurious palace hotel!</li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>-->
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
              <!--content-section-->
            <?php endwhile; ?>
            <?php get_footer(); ?>
        </div><!-- main-wrap -->
        <script type="text/javascript">
          jQuery(document).ready(function () {
              jQuery(".video-thumb").on('touchstart click', function () {
                  var data = jQuery(this).next(".video-block").attr("data");
                  jQuery(this).next(".video-block").attr("src", data);
                  jQuery(this).css("display", "none");
                  jQuery(this).next(".video-block").css("display", "block");

              });
          });
        </script>
        <script>
          jQuery(document).ready(function () {
              jQuery('.faq-question-container').on('click', function () {
                  jQuery(this).parent().toggleClass('active', 1000, 'easeOutSine');
              })
          });
        </script>
    <!--<script src="https://www.thelalit.com/faq.js"></script>-->
    </body>

</html>