<?php
/**
 *
  Template Name: Hotel Template
 *
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage Paper_Plane
 * @since PaperPlane 1.0
 */

 $page_id = get_the_ID();
 $location = get_the_terms($page_id, 'locations');
 $location_id = '';
 foreach($location as $value)
 {
      $location_id = $value->term_id;
 }

 $GLOBALS['location'] = $location;
 $GLOBALS['location_id'] = $location_id;


global $wp;
$position = 1;
$destination_obj = get_destination_by_taxanomy('locations', $location[0]->term_id);
$hotel_name = '';
if($destination_obj->have_posts()){

    while($destination_obj->have_posts()){
        
        $destination_obj->the_post();
        $hotel_name = get_post_meta(get_the_id(), 'name', true);
    }

}
wp_reset_postdata();

$itemList = [];
$itemList[0]['@type'] = 'ListItem';
$itemList[0]['position'] = $position;
$itemList[0]['item']['@id'] = site_url().'/';
$itemList[0]['item']['name'] = 'Home';


$itemList[1]['@type'] = 'ListItem';
$itemList[1]['position'] = $position + 1;
$itemList[1]['item']['@id'] = site_url().'/'.'the-lalit-'.$location[0]->slug.'/';
$itemList[1]['item']['name'] = $hotel_name;

?>

<!DOCTYPE html>
<html lang="en">
   <head>
      <?php wp_head(); ?>
      <?php get_template_part('includes/css', 'js'); ?>
        <script type="application/ld+json">
        {
            "@context": "http://schema.org",
            "@type": "BreadcrumbList",
            "itemListElement": <?php echo json_encode($itemList); ?>
        }
        </script>
        <?php
    if($GLOBALS['location'])
    {
        if($GLOBALS['location'][0]->slug == 'bangalore')
        {
?>
          	<script type="application/ld+json">
{
"@context": "https://schema.org",
"@type": "Hotel",
"name": "The LaLiT Ashok Bangalore",
"image": "https://www.thelalit.com/wp-content/themes/lalit/images/head-logo.png",
"@id": "",
"url": "https://www.thelalit.com/the-lalit-bangalore/",
"telephone": "080 6817 7777",
"address": {
"@type": "PostalAddress",
"streetAddress": "Kumarakrupa Rd, High Grounds, Seshadripuram",
"addressLocality": "Bengaluru",
"postalCode": "560001",
"addressCountry": "IN"
},
"openingHoursSpecification": {
"@type": "OpeningHoursSpecification",
"dayOfWeek": [
"Monday",
"Tuesday",
"Wednesday",
"Thursday",
"Friday",
"Saturday",
"Sunday"
],
"opens": "00:00",
"closes": "23:59"
},
"sameAs": [
"https://www.facebook.com/TheLalitBangalore/",
"https://twitter.com/TheLalitGroup",
"https://www.youtube.com/c/TheLalitGroup",
"https://www.linkedin.com/company/thelalitgroup",
"https://www.instagram.com/thelalitgroup"
]
}
</script>

<?php
        }
        else if($GLOBALS['location'][0]->slug == 'bekal')
        {
?>
  <script type="application/ld+json">
{
"@context": "https://schema.org",
"@type": "Hotel",
"name": "The LaLiT Resort & Spa Bekal",
"image": "https://www.thelalit.com/wp-content/themes/lalit/images/head-logo.png",
"@id": "",
"url": "https://www.thelalit.com/the-lalit-bekal/",
"telephone": "0467 223 7777",
"address": {
"@type": "PostalAddress",
"streetAddress": "Padinhar Road, Udma, Kasaragod",
"addressLocality": "Kerala",
"postalCode": "671319",
"addressCountry": "IN"
},
"openingHoursSpecification": {
"@type": "OpeningHoursSpecification",
"dayOfWeek": [
"Monday",
"Tuesday",
"Wednesday",
"Thursday",
"Friday",
"Saturday",
"Sunday"
],
"opens": "00:00",
"closes": "23:59"
},
"sameAs": [
"https://www.facebook.com/TheLalitBekal/",
"https://twitter.com/TheLalitGroup",
"https://www.youtube.com/c/TheLalitGroup",
"https://www.linkedin.com/company/thelalitgroup",
"https://www.instagram.com/thelalitgroup"
]
}
</script>

<?php
        }
        else if($GLOBALS['location'][0]->slug == 'chandigarh')
        {
?>
        <script type="application/ld+json">
{
"@context": "https://schema.org",
"@type": "Hotel",
"name": "The LaLiT Chandigarh",
"image": "https://www.thelalit.com/wp-content/themes/lalit/images/head-logo.png",
"@id": "",
"url": "https://www.thelalit.com/the-lalit-chandigarh/",
"telephone": "172 676 7777",
"address": {
"@type": "PostalAddress",
"streetAddress": "IT Park Rd",
"addressLocality": "Chandigarh",
"postalCode": "160101",
"addressCountry": "IN"
},
"openingHoursSpecification": {
"@type": "OpeningHoursSpecification",
"dayOfWeek": [
"Monday",
"Tuesday",
"Wednesday",
"Thursday",
"Friday",
"Saturday",
"Sunday"
],
"opens": "00:00",
"closes": "23:59"
},
"sameAs": [
"https://www.facebook.com/TheLalitHotelChandigarh/",
"https://twitter.com/TheLalitGroup",
"https://www.youtube.com/c/TheLalitGroup",
"https://www.linkedin.com/company/thelalitgroup",
"https://www.instagram.com/thelalitgroup"
]
}
</script>

<?php
        }
        else if($GLOBALS['location'][0]->slug == 'goa')
        {
?>
        <script type="application/ld+json">
{
"@context": "https://schema.org",
"@type": "Hotel",
"name": "The LaLiT Golf & Spa Resort Goa",
"image": "https://www.thelalit.com/wp-content/themes/lalit/images/head-logo.png",
"@id": "",
"url": "https://www.thelalit.com/the-lalit-goa/",
"telephone": "0832 266 7777",
"address": {
"@type": "PostalAddress",
"streetAddress": "Raj Baga, Palolem, Canacona",
"addressLocality": "Goa",
"postalCode": "403702",
"addressCountry": "IN"
},
"openingHoursSpecification": {
"@type": "OpeningHoursSpecification",
"dayOfWeek": [
"Monday",
"Tuesday",
"Wednesday",
"Thursday",
"Friday",
"Saturday",
"Sunday"
],
"opens": "00:00",
"closes": "23:59"
},
"sameAs": [
"https://www.facebook.com/TheLalitGoa/",
"https://twitter.com/TheLalitGroup",
"https://www.youtube.com/c/TheLalitGroup",
"https://www.linkedin.com/company/thelalitgroup",
"https://www.instagram.com/thelalitgroup"
]
}
</script>

<?php
        }
        else if($GLOBALS['location'][0]->slug == 'jaipur')
        {
?>
  <script type="application/ld+json">
{
"@context": "https://schema.org",
"@type": "Hotel",
"name": "The Lalit Jaipur",
"image": "https://www.thelalit.com/wp-content/themes/lalit/images/head-logo.png",
"@id": "",
"url": "https://www.thelalit.com/the-lalit-jaipur/",
"telephone": "0141 519 7777",
"address": {
"@type": "PostalAddress",
"streetAddress": "Jawahar Circle 2B & 2C, Jagatpura Rd, near Jagatpura Road, Malviya Nagar",
"addressLocality": "Jaipur",
"postalCode": "302017",
"addressCountry": "IN"
},
"openingHoursSpecification": {
"@type": "OpeningHoursSpecification",
"dayOfWeek": [
"Monday",
"Tuesday",
"Wednesday",
"Thursday",
"Friday",
"Saturday",
"Sunday"
],
"opens": "00:00",
"closes": "23:59"
},
"sameAs": [
"https://www.facebook.com/TheLalitJaipur",
"https://twitter.com/TheLalitGroup",
"https://www.youtube.com/c/TheLalitGroup",
"https://www.linkedin.com/company/thelalitgroup",
"https://www.instagram.com/thelalitgroup"
]
}
</script>

<?php
        }
        else if($GLOBALS['location'][0]->slug == 'khajuraho')
        {
?>
        <script type="application/ld+json">
{
"@context": "https://schema.org",
"@type": "Hotel",
"name": "The LaLiT Temple View Khajuraho",
"image": "https://www.thelalit.com/wp-content/themes/lalit/images/head-logo.png",
"@id": "",
"url": "https://www.thelalit.com/the-lalit-khajuraho/",
"telephone": "099930 92600",
"address": {
"@type": "PostalAddress",
"streetAddress": "opposite Circuit House, Sevagram",
"addressLocality": "Khajuraho",
"postalCode": "471606",
"addressCountry": "IN"
},
"openingHoursSpecification": {
"@type": "OpeningHoursSpecification",
"dayOfWeek": [
"Monday",
"Tuesday",
"Wednesday",
"Thursday",
"Friday",
"Saturday",
"Sunday"
],
"opens": "00:00",
"closes": "23:59"
},
"sameAs": [
"https://www.facebook.com/TheLalitKhajuraho/",
"https://twitter.com/TheLalitGroup",
"https://www.youtube.com/c/TheLalitGroup",
"https://www.linkedin.com/company/thelalitgroup",
"https://www.instagram.com/thelalitgroup"
]
}
</script>

<?php
        }
        else if($GLOBALS['location'][0]->slug == 'kolkata')
        {
?>
        <script type="application/ld+json">
{
"@context": "https://schema.org",
"@type": "Hotel",
"name": "The LaLiT Great Eastern Kolkata",
"image": "https://www.thelalit.com/wp-content/themes/lalit/images/head-logo.png",
"@id": "",
"url": "https://www.thelalit.com/the-lalit-kolkata/",
"telephone": "033 4444 7777",
"address": {
"@type": "PostalAddress",
"streetAddress": "Dalhousie Square 1, 2,3, Old Court House St, Ward Number 1",
"addressLocality": "Kolkata",
"postalCode": "700069",
"addressCountry": "IN"
},
"openingHoursSpecification": {
"@type": "OpeningHoursSpecification",
"dayOfWeek": [
"Monday",
"Tuesday",
"Wednesday",
"Thursday",
"Friday",
"Saturday",
"Sunday"
],
"opens": "00:00",
"closes": "23:59"
},
"sameAs": [
"https://www.facebook.com/TheLalitKolkata/",
"https://twitter.com/TheLalitGroup",
"https://www.youtube.com/c/TheLalitGroup",
"https://www.linkedin.com/company/thelalitgroup",
"https://www.instagram.com/thelalitgroup"
]
}
</script>

<?php
        }
        else if($GLOBALS['location'][0]->slug == 'london')
        {
?>
  <script type="application/ld+json">
{
"@context": "https://schema.org",
"@type": "Hotel",
"name": "The LaLiT London",
"image": "https://www.thelalit.com/wp-content/themes/lalit/images/head-logo.png",
"@id": "",
"url": "https://www.thelalit.com/the-lalit-london/",
"telephone": "20 3765 0000",
"address": {
"@type": "PostalAddress",
"streetAddress": "181 Tooley St",
"addressLocality": "London",
"postalCode": "SE1 2JR",
"addressCountry": "GB"
},
"openingHoursSpecification": {
"@type": "OpeningHoursSpecification",
"dayOfWeek": [
"Monday",
"Tuesday",
"Wednesday",
"Thursday",
"Friday",
"Saturday",
"Sunday"
],
"opens": "00:00",
"closes": "23:59"
},
"sameAs": [
"https://www.facebook.com/TheLalitLondon",
"https://twitter.com/TheLalitGroup",
"https://www.youtube.com/c/TheLalitGroup",
"https://www.linkedin.com/company/thelalitgroup",
"https://www.instagram.com/thelalitgroup"
]
}
</script>


<?php
        }
        else if($GLOBALS['location'][0]->slug == 'mangar')
        {
?>
        <script type="application/ld+json">
            {
            "@context": "http://schema.org",
            "@type": "Hotel",
            "name": "The LaLiT Mangar",
            "image": "https://www.thelalit.com/wp-content/uploads/2017/02/The-Lalit-Mangar-1.png",
            "priceRange" : "₹ 150 - ₹ 75,000",
            "@id": "https://www.thelalit.com/the-lalit-mangar",
            "url": "https://www.thelalit.com/",
            "telephone": "+911297157777",
            "address": {
                "@type": "PostalAddress",
                "streetAddress": "Camp Wild Road Near Mangar Police Chowki, Faridabad-Gurugram Road, Faridabad, Haryana",
                "addressLocality": "Faridabad",
                "postalCode": "121001",
                "addressCountry": "IN"
            },
            "geo": {
                "@type": "GeoCoordinates",
                "latitude": 28.3820654,
                "longitude": 77.1742213
            },
            "openingHoursSpecification": {
                "@type": "OpeningHoursSpecification",
                "dayOfWeek": [
                "Monday",
                "Tuesday",
                "Wednesday",
                "Thursday",
                "Friday",
                "Saturday",
                "Sunday"
                ],
                "opens": "00:00",
                "closes": "23:59"
            },
            "sameAs": "https://www.facebook.com/TheLalitMangar"
            }
        </script>
<?php
        }
        else if($GLOBALS['location'][0]->slug == 'mumbai')
        {
?>
        <script type="application/ld+json">
{
"@context": "https://schema.org",
"@type": "Hotel",
"name": "The LaLiT Mumbai",
"image": "https://www.thelalit.com/wp-content/themes/lalit/images/head-logo.png",
"@id": "",
"url": "https://www.thelalit.com/the-lalit-mumbai/",
"telephone": "022 6699 2222",
"address": {
"@type": "PostalAddress",
"streetAddress": "Sahar Airport Rd, Navpada, Marol, Andheri East",
"addressLocality": "Mumbai",
"postalCode": "400059",
"addressCountry": "IN"
},
"openingHoursSpecification": {
"@type": "OpeningHoursSpecification",
"dayOfWeek": [
"Monday",
"Tuesday",
"Wednesday",
"Thursday",
"Friday",
"Saturday",
"Sunday"
],
"opens": "00:00",
"closes": "23:59"
},
"sameAs": [
"https://www.facebook.com/TheLalitMumbai",
"https://twitter.com/TheLalitGroup",
"https://www.youtube.com/c/TheLalitGroup",
"https://www.linkedin.com/company/thelalitgroup",
"https://www.instagram.com/thelalitgroup"
]
}
</script>

<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "FAQPage",
  "mainEntity": [
    {
      "@type": "Question",
      "name": "Why is The LaLiT Mumbai considered one of the best 5-star luxury hotels in Mumbai?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "The LaLiT Mumbai is a landmark of opulence, offering an unparalleled blend of elegance, comfort, and world-class hospitality. Located near Mumbai’s international airport, this 5-star luxury hotel features lavish accommodations, award-winning fine dining, a revitalizing spa, and state-of-the-art business facilities. Whether visiting for business or leisure, guests can expect seamless service, contemporary design, and an indulgent retreat in the heart of India’s financial capital."
      }
    },
    {
      "@type": "Question",
      "name": "Where is The LaLiT Mumbai located?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "Strategically situated in Andheri East, The LaLiT Mumbai offers prime connectivity to Chhatrapati Shivaji Maharaj International Airport (1 km | 5-minute drive), key corporate hubs, and Mumbai’s premier shopping and entertainment districts. The hotel’s location ensures a serene escape from the city’s bustle while providing effortless access to major landmarks."
      }
    },
    {
      "@type": "Question",
      "name": "What types of accommodations are available at this luxury hotel?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "The sumptuously designed rooms and suites at The LaLiT Mumbai offer sophisticated interiors, plush furnishings, and modern amenities for a truly indulgent experience. Guests can choose from:
Deluxe Rooms – Offering panoramic city or garden views, with contemporary design and refined elegance.
Luxury Suites – Featuring expansive living areas, bespoke décor, and exclusive privileges.
The LaLiT Legacy Suite (Presidential Suite) – A magnificent retreat, boasting exquisite interiors, personalized butler service, and breathtaking skyline views."
      }
    },
    {
      "@type": "Question",
      "name": "What are the best fine dining experiences at The LaLiT Mumbai?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "The LaLiT Mumbai offers an exquisite culinary journey, where master chefs curate authentic Indian and global flavors in an ambiance of refined luxury. Dining options include:
 24/7 Restaurant – A multi-cuisine all-day dining experience, serving international delicacies round the clock.
 Baluchi – The hotel’s signature Pan-Indian restaurant, renowned for its flavorsome Awadhi and North-Western frontier cuisine.
OKO – An award-winning Pan-Asian fine dining destination, serving the finest Japanese, Thai, and Chinese delicacies."
      }
    },
    {
      "@type": "Question",
      "name": "What are the finest nightlife and entertainment options at the hotel?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "Elevating Mumbai’s nightlife scene, The LaLiT Mumbai presents sophisticated lounges and exclusive bars, perfect for unwinding and socializing:
Beluga – A chic cocktail lounge with an extensive selection of premium spirits and handcrafted beverages.
Kitty Su – One of Mumbai’s most iconic nightclubs, offering electrifying music, avant-garde performances, and signature events.
In-Room Dining – Enjoy a gourmet meal in the privacy of your suite, with a meticulously curated menu available 24/7."
      }
    },
    {
      "@type": "Question",
      "name": "What wellness and spa facilities does The LaLiT Mumbai offer?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "The Spa at The LaLiT Mumbai is an oasis of serenity, offering holistic therapies and rejuvenating treatments to restore mind, body, and soul. Guests can indulge in:
 Ayurvedic Rituals & Aromatherapy Massages – Experience deep relaxation with traditional healing techniques.
Luxury Facials, Body Wraps & Detox Treatments – Indulge in premium skincare and rejuvenation therapies.
State-of-the-Art Fitness Center – Equipped with advanced machines and personal training services.
Tranquil Swimming Pool – A refreshing retreat from the fast-paced city life."
      }
    },
    {
      "@type": "Question",
      "name": "What unique experiences can guests enjoy at this luxury hotel?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "The LaLiT Mumbai curates extraordinary experiences that elevate every stay, including:
Private Dining Under the Stars – Enjoy an intimate gourmet experience with a specially curated menu.
Culinary Masterclasses – Learn from the hotel’s renowned chefs in exclusive cooking sessions.
Exclusive Spa Journeys – A blend of traditional healing techniques and modern therapies for ultimate relaxation.
Bespoke Concierge Services – Tailored city tours, luxury shopping experiences, and cultural excursions."
      }
    },
    {
      "@type": "Question",
      "name": "What are the top attractions near The LaLiT Mumbai?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "The hotel’s prime location provides easy access to Mumbai’s most iconic landmarks, including:
Juhu Beach (6 km | 15-minute drive | Taxi, Private Car)
Bandra-Worli Sea Link (14 km | 30-minute drive | Taxi, Private Car)
Gateway of India & Colaba Causeway (26 km | 50-minute drive | Private Car)
Siddhivinayak Temple (12 km | 25-minute drive | Taxi, Private Car)
Phoenix Marketcity Mall (4 km | 10-minute drive | Taxi, Private Car)"
      }
    },
    {
      "@type": "Question",
      "name": "Does The LaLiT Mumbai provide airport transfers and business facilities?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "Yes, The LaLiT Mumbai offers luxury airport transfers, ensuring a seamless arrival and departure experience. Additionally, the hotel features state-of-the-art business facilities, including:
Private Chauffeur-Driven Car Services
Limousine Transfers – Available upon request.
Dedicated Business Lounges & High-Tech Conference Rooms – Ideal for corporate travelers."
      }
    },
    {
      "@type": "Question",
      "name": "How can I book my stay at this 5-star luxury hotel in Mumbai?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "Guests can book directly through The LaLiT Mumbai’s official website for exclusive privileges, including:
Early Booking Discounts & Customized Luxury Packages
Personalized Concierge Assistance – Ensuring an extraordinary stay.
Book your stay today and immerse yourself in Mumbai’s most prestigious luxury experience!"
      }
    }
  ]
}

</script>
<?php
        }
        else if($GLOBALS['location'][0]->slug == 'delhi')
        {
?>
        <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Hotel",
  "name": "The LaLiT New Delhi",
  "image": "https://www.thelalit.com/wp-content/themes/lalit/images/head-logo.png",
  "@id": "",
  "url": "https://www.thelalit.com/the-lalit-delhi/",
  "telephone": "011 4444 7777",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "Barakhamba Avenue, Connaught Place",
    "addressLocality": "New Delhi",
    "postalCode": "110001",
    "addressCountry": "IN"
  },
  "openingHoursSpecification": {
    "@type": "OpeningHoursSpecification",
    "dayOfWeek": [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday",
      "Sunday"
    ],
    "opens": "00:00",
    "closes": "23:59"
  },
  "sameAs": [
    "https://www.facebook.com/TheLalitNewDelhi",
    "https://twitter.com/TheLalitGroup",
    "https://www.youtube.com/c/TheLalitGroup",
    "https://www.linkedin.com/company/thelalitgroup",
    "https://www.instagram.com/thelalitgroup"
  ] 
}
</script>

<?php
        }
        else if($GLOBALS['location'][0]->slug == 'srinagar')
        {
?>
        <script type="application/ld+json">
{
"@context": "https://schema.org",
"@type": "Hotel",
"name": "The LaLiT Grand Palace Srinagar",
"image": "https://www.thelalit.com/wp-content/themes/lalit/images/head-logo.png",
"@id": "",
"url": "https://www.thelalit.com/the-lalit-srinagar/",
"telephone": "0194 250 1001",
"address": {
"@type": "PostalAddress",
"streetAddress": "Gupkar Rd, Srinagar",
"addressLocality": "Jammu and Kashmir",
"postalCode": "190001",
"addressCountry": "IN"
},
"openingHoursSpecification": {
"@type": "OpeningHoursSpecification",
"dayOfWeek": [
"Monday",
"Tuesday",
"Wednesday",
"Thursday",
"Friday",
"Saturday",
"Sunday"
],
"opens": "00:00",
"closes": "23:59"
},
"sameAs": [
"https://www.facebook.com/TheLalitSrinagar/",
"https://twitter.com/TheLalitGroup",
"https://www.youtube.com/c/TheLalitGroup",
"https://www.linkedin.com/company/thelalitgroup",
"https://www.instagram.com/thelalitgroup"
]
}
</script>

<?php
        }
        else if($GLOBALS['location'][0]->slug == 'udaipur')
        {
?>
        <script type="application/ld+json">
{
"@context": "https://schema.org",
"@type": "Hotel",
"name": "The LaLiT Laxmi Vilas Palace Udaipur",
"image": "https://www.thelalit.com/wp-content/themes/lalit/images/head-logo.png",
"@id": "",
"url": "https://www.thelalit.com/the-lalit-udaipur/",
"telephone": "0294 661 7777",
"address": {
"@type": "PostalAddress",
"streetAddress": "Fateh Sagar Rd, Near Zinc, Fateh Sagar Lake",
"addressLocality": "Udaipur",
"postalCode": "313004",
"addressCountry": "IN"
},
"openingHoursSpecification": {
"@type": "OpeningHoursSpecification",
"dayOfWeek": [
"Monday",
"Tuesday",
"Wednesday",
"Thursday",
"Friday",
"Saturday",
"Sunday"
],
"opens": "00:00",
"closes": "23:59"
},
"sameAs": [
"https://www.facebook.com/TheLalitUdaipur/",
"https://twitter.com/TheLalitGroup",
"https://www.youtube.com/c/TheLalitGroup",
"https://www.linkedin.com/company/thelalitgroup",
"https://www.instagram.com/thelalitgroup"
]
}
</script>

<?php
        }
    }
?>

<!-- popups css-->
<style>
.cta-bar{border-radius:8px;background:#fff;
box-shadow: -4px 4px 9.8px 0px rgba(255, 255, 255, 0.29) inset, 0px 8px 19.2px -10px #256200; width:200px; height:auto; position:fixed; bottom:20px; right:20px; z-index:999999;}
.mobil-app-box{position:relative; overflow:hidden;}
.mobil-app-box img{background:#fff;height: auto;width: auto; border-radius:4px; margin:10px; width:90%; margin-top:15px;}
.close-offer {position: absolute;right: -14px;top: -13px;font-size:14px;cursor: pointer;background: #fff;padding: 7px;border-radius: 100%;width: 10px;height: 10px;color: #000;line-height:9px;border: 1px solid #444;display: flex;justify-content: center;}
</style>
<!-- popups css end-->



   </head>
   <body <?php body_class('home-temp lalit-booking-widget hotel-temp'); ?>>

   <?php if($GLOBALS['location'][0]->slug == 'mumbai') { ?>
   <!----- HTML ----->
<div class="cta-bar">
<div class="mobil-app-box">

</div>

</div>

  <?php } ?> 


      <div class="main-wrap">
         <?php get_header(); ?>

            <?php get_template_part( 'template-parts/hotel', 'overview' ); ?>
			

<?php /*  if($GLOBALS['location'][0]->slug == 'mumbai') { ?>
<div class="container fluid-width section-space clearfix container-shadow" style="padding-top: 110px;">
<div class="row clearfix"><h2 class="sec-title align-center page-title-home">Frequently Asked Questions</h2>

<div class="frequently-questions-div">

<div class="question active">
<h5>Q: Why is The LaLiT Mumbai considered one of the best 5-star luxury hotels in
Mumbai?  </h5>
<div class="arrow"></div>
<div class="answer" style="display: block;">
<p>A: The LaLiT Mumbai is a landmark of opulence, offering an unparalleled blend
of elegance, comfort, and world-class hospitality. Located near Mumbai’s
international airport, this 5-star luxury hotel features lavish
accommodations, award-winning fine dining, a revitalizing spa, and state-
of-the-art business facilities. Whether visiting for business or leisure, guests
can expect seamless service, contemporary design, and an indulgent
retreat in the heart of India’s financial capital.</p>
</div></div>

<div class="question">
<h5>Q: Where is The LaLiT Mumbai located?  </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Strategically situated in Andheri East, The LaLiT Mumbai offers prime
connectivity to Chhatrapati Shivaji Maharaj International Airport (1 km | 5-
minute drive), key corporate hubs, and Mumbai’s premier shopping and
entertainment districts. The hotel’s location ensures a serene escape from
the city’s bustle while providing effortless access to major landmarks.</p>

</div></div>

<div class="question">
<h5>Q: What types of accommodations are available at this luxury hotel?  </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The sumptuously designed rooms and suites at The LaLiT Mumbai offer
sophisticated interiors, plush furnishings, and modern amenities for a truly
indulgent experience. Guests can choose from:
 </p>
<ul>
<li>Deluxe Rooms – Offering panoramic city or garden views, with
contemporary design and refined elegance.</li>
<li>Luxury Suites – Featuring expansive living areas, bespoke décor, and
exclusive privileges.</li>
<li>The LaLiT Legacy Suite (Presidential Suite) – A magnificent retreat,
boasting exquisite interiors, personalized butler service, and
breathtaking skyline views</li>
 
</ul>

</div></div>

<div class="question">
<h5>Q: What are the best fine dining experiences at The LaLiT Mumbai?  </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The LaLiT Mumbai offers an exquisite culinary journey, where master chefs
curate authentic Indian and global flavors in an ambiance of refined luxury.
Dining options include:</p>
<ul>
<li>24/7 Restaurant – A multi-cuisine all-day dining experience, serving
international delicacies round the clock.</li>
<li>Baluchi – The hotel’s signature Pan-Indian restaurant, renowned for its
flavorsome Awadhi and North-Western frontier cuisine.</li>
<li>OKO – An award-winning Pan-Asian fine dining destination, serving the
finest Japanese, Thai, and Chinese delicacies.</li>
 
</ul>
</div></div>

<div class="question">
<h5>Q: What are the finest nightlife and entertainment options at the hotel?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Elevating Mumbai’s nightlife scene, The LaLiT Mumbai presents sophisticated
lounges and exclusive bars, perfect for unwinding and socializing:</p>
<ul>
    <li><strong>Beluga</strong> – A chic cocktail lounge with an extensive selection of premium spirits and handcrafted beverages.</li>
    <li><strong>Kitty Su</strong> – One of Mumbai’s most iconic nightclubs, offering electrifying music, avant-garde performances, and signature events.</li>
    <li><strong>In-Room Dining</strong> – Enjoy a gourmet meal in the privacy of your suite, with a meticulously curated menu available 24/7.</li>
</ul>
</div></div>

<div class="question">
<h5>Q: What wellness and spa facilities does The LaLiT Mumbai offer?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The Spiceology Spa at The LaLiT Mumbai is an oasis of serenity, offering
holistic therapies and rejuvenating treatments to restore mind, body, and
soul. Guests can indulge in:</p>
<ul>
    <li><strong>Ayurvedic Rituals & Aromatherapy Massages</strong> – Experience deep relaxation with traditional healing techniques.</li>
    <li><strong>Luxury Facials, Body Wraps & Detox Treatments</strong> – Indulge in premium skincare and rejuvenation therapies.</li>
    <li><strong>State-of-the-Art Fitness Center</strong> – Equipped with advanced machines and personal training services.</li>
    <li><strong>Tranquil Swimming Pool</strong> – A refreshing retreat from the fast-paced city life.</li>
</ul>

</div></div>

<div class="question">
<h5>Q: What unique experiences can guests enjoy at this luxury hotel?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The LaLiT Mumbai curates extraordinary experiences that elevate every stay,
including:</p>
<ul>
    <li><strong>Private Dining Under the Stars</strong> – Enjoy an intimate gourmet experience with a specially curated menu.</li>
    <li><strong>Culinary Masterclasses</strong> – Learn from the hotel’s renowned chefs in exclusive cooking sessions.</li>
    <li><strong>Exclusive Spa Journeys</strong> – A blend of traditional healing techniques and modern therapies for ultimate relaxation.</li>
    <li><strong>Bespoke Concierge Services</strong> – Tailored city tours, luxury shopping experiences, and cultural excursions.</li>
</ul>


</div></div>


<div class="question">
<h5>Q: What are the top attractions near The LaLiT Mumbai?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The hotel’s prime location provides easy access to Mumbai’s most iconic
landmarks, including:</p>
<ul>
    <li><strong>Juhu Beach</strong> (6 km | 15-minute drive | Taxi, Private Car)</li>
    <li><strong>Bandra-Worli Sea Link</strong> (14 km | 30-minute drive | Taxi, Private Car)</li>
    <li><strong>Gateway of India & Colaba Causeway</strong> (26 km | 50-minute drive | Private Car)</li>
    <li><strong>Siddhivinayak Temple</strong> (12 km | 25-minute drive | Taxi, Private Car)</li>
    <li><strong>Phoenix Marketcity Mall</strong> (4 km | 10-minute drive | Taxi, Private Car)</li>
</ul>



</div></div>


<div class="question">
<h5>Q: Does The LaLiT Mumbai provide airport transfers and business facilities?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Yes! The hotel offers luxury airport transfers, ensuring a seamless arrival and
departure experience. Guests can avail:</p>
<ul>
    <li><strong>Private Chauffeur-Driven Car Services</strong></li>
    <li><strong>Limousine Transfers</strong> – Available upon request.</li>
    <li><strong>Dedicated Business Lounges & High-Tech Conference Rooms</strong> – Ideal for corporate travelers.</li>
</ul>


</div></div>


<div class="question">
<h5>Q: How can I book my stay at this 5-star luxury hotel in Mumbai?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Guests can book directly through The LaLiT Mumbai’s official website for
exclusive privileges, including:</p>
<ul>
    <li><strong>Early Booking Discounts & Customized Luxury Packages</strong></li>
    <li><strong>Personalized Concierge Assistance</strong> – Ensuring an extraordinary stay.</li>
</ul>
<p><strong>Book your stay today</strong> and immerse yourself in Mumbai’s most prestigious luxury experience!</p>


</div></div>

</div>

</div></div>
<?php } else if($GLOBALS['location'][0]->slug == 'bangalore') { ?>
<div class="container fluid-width section-space clearfix container-shadow" style="padding-top: 110px;">
<div class="row clearfix"><h2 class="sec-title align-center page-title-home">Frequently Asked Questions</h2>

<div class="frequently-questions-div">



</div>
</div>
</div>
 
<?php } else if($GLOBALS['location'][0]->slug == 'bekal') { ?>
<div class="container fluid-width section-space clearfix container-shadow" style="padding-top: 110px;">
<div class="row clearfix"><h2 class="sec-title align-center page-title-home">Frequently Asked Questions</h2>

<div class="frequently-questions-div">



</div>
</div>
</div>
 
 
<?php } else if($GLOBALS['location'][0]->slug == 'delhi') { ?>
<div class="container fluid-width section-space clearfix container-shadow" style="padding-top: 110px;">
<div class="row clearfix"><h2 class="sec-title align-center page-title-home">Frequently Asked Questions</h2>

<div class="frequently-questions-div">

<div class="question active">
<h5>Q:	What makes The LaLiT New Delhi one of the best 5-star luxury hotels in Delhi? </h5>
<div class="arrow"></div>
<div class="answer" style="display: block;">
<p>A: The LaLiT New Delhi stands as a premier 5-star luxury hotel, redefining elegance, sophistication, and world-class hospitality. Nestled in the heart of India’s capital, this architectural masterpiece offers a seamless blend of timeless grandeur and contemporary opulence. Featuring lavishly designed accommodations, award-winning gourmet dining, an indulgent luxury spa, and cutting-edge business facilities, The LaLiT ensures an unparalleled experience for both leisure seekers and corporate travelers. Whether you're here to explore Delhi’s rich cultural heritage or to attend high-powered business engagements, this iconic luxury hotel promises an extraordinary stay, infused with personalized service and refined elegance.  </p>
</div></div>

<div class="question">
<h5>Q:	Where is The LaLiT New Delhi located?  </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: This 5-star hotel in Delhi is conveniently located in Connaught Place, one of the city's most prestigious and vibrant areas. It offers easy access to key attractions like India Gate, Rashtrapati Bhavan, Red Fort, and major business hubs, making it an ideal stay for tourists and corporate guests.</p>

</div></div>

<div class="question">
<h5>Q:	What types of rooms and suites are available at The LaLiT New Delhi?  </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The LaLiT New Delhi offers a variety of luxury accommodations, including:</p>
<ul>
<li><strong> Luxury Rooms –</strong> Elegant and spacious with modern amenities.</li>
<li><strong> Executive Suites –</strong> Featuring a separate living area for added comfort.</li>
<li><strong> The LaLiT Legacy Suite (Presidential Suite) –</strong> The ultimate in opulence with panoramic city views, exclusive services, and personalized luxury.</li>

</ul>

</div></div>

<div class="question">
<h5>Q:	What dining options are available at this 5-star hotel in Delhi? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The hotel boasts some of the best fine dining restaurants in Delhi, including:</p>
<ul>
<li><strong>24/7 Restaurant –</strong> Global cuisine available round the clock.</li>
<li><strong>Baluchi –</strong> An authentic Indian culinary experience.</li>
<li><strong>OKO –</strong> A Pan-Asian restaurant offering delicacies from Japan, Thailand, and China.</li>
<li><strong>The Grill Room –</strong> Specializing in premium cuts and gourmet delights.</li>
<li><strong>24/7 Bar & Le Petit Café –</strong> Offering signature cocktails, wines, and freshly baked treats.</li>
</ul>

</div></div>

<div class="question">
<h5>Q:	What luxury wellness and spa facilities does the hotel offer? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The Spiceology Spa at The LaLiT New Delhi offers a 5-star wellness experience, including:</p>
<ul>
<li> Ayurvedic and aromatherapy treatments.</li>
<li> Deep tissue and Swedish massages for relaxation.</li>
<li> Facials, body wraps, and skin rejuvenation therapies.</li>
<li> A well-equipped fitness center and an outdoor swimming pool for health-conscious guests.</li>
</ul>

</div></div>

<div class="question">
<h5>Q:	What business and event facilities are available at the hotel? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: As one of the best hotels for business travelers, The LaLiT New Delhi provides:</p>
<ul>
<li>	Spacious conference rooms and banquet halls with modern technology.</li>
<li>	Boardrooms and business lounges for corporate meetings.</li>
<li>	Event planning services for weddings, exhibitions, and grand celebrations.</li>
</ul>

</div></div>

<div class="question">
<h5>Q:	What are the best attractions near The LaLiT New Delhi? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Staying at this 5-star luxury hotel in Delhi provides easy access to top attractions, including:</p>
<ul>
<li>	India Gate (4 km | 10-minute drive | Taxi, Private Car, Tuk-Tuk)</li>
<li>	Rashtrapati Bhavan (Presidential Residence) (5 km | 12-minute drive | Taxi, Private Car)</li>
<li>	Connaught Place – Shopping & Nightlife Hub (1.5 km | 5-minute drive | Walk, Taxi, Tuk-Tuk)</li>
<li>	Lotus Temple (14 km | 25-minute drive | Taxi, Private Car)</li>
<li>	Akshardham Temple (11 km | 20-minute drive | Taxi, Private Car)</li>
<li>	Red Fort (6.5 km | 15-minute drive | Taxi, Private Car)</li>
<li>	Jama Masjid (5.5 km | 12-minute drive | Taxi, Private Car, Tuk-Tuk)</li>
<li>	Chandni Chowk – Street Food & Heritage Shopping (6 km | 15-minute drive | Taxi, Tuk-Tuk, Cycle Rickshaw)</li>
<li>	Qutub Minar (16 km | 30-minute drive | Taxi, Private Car)</li>
<li>	Humayun’s Tomb (8 km | 18-minute drive | Taxi, Private Car)</li>
</ul>

</div></div>

<div class="question">
<h5>Q:	Does The LaLiT New Delhi offer airport transfers and concierge services? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Yes, the hotel provides luxury airport transfers in chauffeur-driven cars. The 24-hour concierge service assists with travel arrangements, sightseeing tours, and personalized itineraries to ensure guests experience the best of Delhi.</p>

</div></div>

<div class="question">
<h5>Q:	Is The LaLiT New Delhi suitable for a romantic getaway or honeymoon?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Absolutely! The best 5-star hotel for couples in Delhi, The LaLiT offers:</p>
<ul>
<li>	Romantic suites with breathtaking city views.</li>
<li>	Private candlelight dining experiences.</li>
<li>	Spa packages for couples.</li>
<li>	Special honeymoon packages with luxury inclusions.</li>

</ul>

</div></div>

<div class="question">
<h5>Q:	How can I book a stay at this luxury hotel in Delhi? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Guests can book directly through The LaLiT New Delhi’s official website for exclusive offers, or via leading travel platforms. Special benefits include:</p>
<ul>
<li>	Best available rates with early booking discounts.</li>
<li>	Personalized services for enhanced stay experience.</li>
</ul>

</div></div>

</div>
</div>
</div>
<?php } else if($GLOBALS['location'][0]->slug == 'jaipur') { ?>
<div class="container fluid-width section-space clearfix container-shadow" style="padding-top: 110px;">
<div class="row clearfix"><h2 class="sec-title align-center page-title-home">Frequently Asked Questions</h2>

<div class="frequently-questions-div">

<div class="question active">
<h5>Q:	Why is The LaLiT Jaipur considered one of the best 5-star luxury hotels in Jaipur? </h5>
<div class="arrow"></div>
<div class="answer" style="display: block;">
<p>A: The LaLiT Jaipur is a symbol of grandeur and regal hospitality, offering an unparalleled blend of Rajasthani heritage and modern luxury. Located in the heart of the Pink City, this 5-star luxury hotel is renowned for its opulent accommodations, award-winning dining, a world-class spa, and elegant event venues. Whether you’re visiting for business, leisure, or a grand celebration, The LaLiT Jaipur ensures a royal experience infused with warmth, sophistication, and impeccable service. </p>
</div></div>

<div class="question">
<h5>Q:	Where is The LaLiT Jaipur located? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The LaLiT Jaipur is strategically located near Jaipur International Airport (3 km | 10-minute drive), offering seamless connectivity to key landmarks such as:</p>
<ul>
<li> 	Amber Fort (15 km | 30-minute drive)</li>
<li> 	Hawa Mahal (12 km | 25-minute drive)</li>
<li> 	City Palace & Jantar Mantar (13 km | 30-minute drive)</li>
<li> 	Jaipur Exhibition and Convention Centre (8 km | 15-minute drive)</li>

</ul>

</div></div>

<div class="question">
<h5>Q:	What types of accommodations are available at this luxury hotel?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The exquisitely designed rooms and suites at The LaLiT Jaipur provide an indulgent retreat, blending traditional Rajasthani aesthetics with contemporary elegance. Options include:</p>
<ul>
<li><strong>	Deluxe Rooms –</strong> Stylish interiors with plush bedding and modern amenities.</li>
<li><strong>	Luxury Suites –</strong> Offering spacious living areas, handcrafted decor, and premium furnishings.</li>
<li><strong>	The LaLiT Legacy Suite (Presidential Suite) –</strong> A palatial haven with a private lounge, grand bedroom, and breathtaking city views.</li>


</ul>

</div></div>

<div class="question">
<h5>Q:	What are the best fine dining experiences at The LaLiT Jaipur?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The LaLiT Jaipur offers an unmatched culinary journey, where every meal is a celebration of authentic flavors and global cuisines:</p>
<ul>
<li><strong>	Baluchi –</strong> The hotel’s signature Pan-Indian fine-dining restaurant, renowned for its North-Western Frontier cuisine and signature Naan’ery.
<li><strong>	The Circle –</strong> An all-day dining restaurant serving a fusion of local Rajasthani delicacies and international flavors.
<li><strong> 24/7 In-Room Dining –</strong> Enjoy gourmet meals in the comfort of your room, available around the clock.
</li>



</ul>

</div></div>

<div class="question">
<h5>Q:	What are the finest wellness and relaxation services at the hotel?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The Spiceology Spa at The LaLiT Jaipur is an oasis of tranquility, offering a curated selection of rejuvenating treatments:</p>

<ul>
<li>	Traditional Ayurvedic massages and aromatherapy sessions for complete relaxation.</li>
<li>	Signature detoxifying facials and body treatments for radiant skin.</li>
<li>	A fully equipped state-of-the-art gymnasium with personalized fitness sessions.</li>
<li>	An outdoor swimming pool featuring a serene lounging area for ultimate rejuvenation.</li>

</ul>

</div></div>

<div class="question">
<h5>Q:	What exclusive experiences can guests enjoy at The LaLiT Jaipur? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Guests can indulge in bespoke luxury experiences, including:</p>
<ul>
<li><strong>	Royal Heritage Walks & Private City Tours –</strong> Explore Jaipur’s historic palaces, bustling bazaars, and cultural landmarks.</li>
<li><strong>	Sunset Camel Safari –</strong> Witness the breathtaking desert sunset while enjoying a traditional Rajasthani cultural performance.</li>
<li><strong>	Private Rooftop Dining –</strong> Experience an intimate candlelit dinner with curated gourmet delicacies and panoramic city views.</li>
<li><strong>	Luxury Shopping Assistance –</strong> Personalized shopping tours to Jaipur’s famous jewelry, textile, and handicraft markets.</li>


</ul>

</div></div>

<div class="question">
<h5>Q:	Is The LaLiT Jaipur a premier venue for weddings and events? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Yes! The LaLiT Jaipur is one of the most sought-after wedding destinations in Jaipur, featuring:</p>
<ul>
<li>	Grand indoor and outdoor wedding venues, including regal banquet halls and sprawling landscape gardens.</li>
<li>	Personalized wedding planning services, ensuring every celebration is flawlessly curated.</li>
<li>	Exquisite catering options, blending authentic Rajasthani, Indian, and international cuisines.</li>
<li>	Premium corporate event facilities, including state-of-the-art boardrooms and conference halls.</li>

</ul>

</div></div>

<div class="question">
<h5>Q:	Which are the top attractions near The LaLiT Jaipur? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Staying at The LaLiT Jaipur provides easy access to Jaipur’s most iconic landmarks, including:</p>
<ul>
<li><strong> 	Amber Fort</strong> (15 km | 30-minute drive | Private Car, Taxi)</li>
<li><strong>	Hawa Mahal</strong> (12 km | 25-minute drive | Private Car, Tuk-Tuk)</li>
<li><strong>	City Palace & Jantar Mantar</strong> (13 km | 30-minute drive | Taxi, Private Car)</li>
<li><strong>	Nahargarh Fort</strong> (18 km | 35-minute drive | Private Car)</li>
<li><strong>	Albert Hall Museum</strong> (10 km | 20-minute drive | Taxi, Private Car)</li>

</ul>

</div></div>

<div class="question">
<h5>Q:	Does The LaLiT Jaipur offer airport transfers and concierge services?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Absolutely! The hotel provides luxury airport transfers and personalized concierge services, including:</p>
<ul>
<li>	Chauffeur-driven private car services.</li>
<li>	Curated sightseeing tours with expert guides.</li>
<li>	Tailor-made itineraries for a seamless and enriching Jaipur experience.</li>
</ul>

</div></div>

<div class="question">
<h5>Q:	How can I book my stay at this 5-star luxury hotel in Jaipur?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Guests can book their stay directly through The LaLiT Jaipur’s official website for exclusive privileges, including:</p>
<ul>
<li>	Early booking discounts and bespoke luxury packages.</li>
<li>	Tailor-made experiences for a truly unforgettable stay.</li>
</ul>

<p style="padding-top:15px;">Book your stay today and immerse yourself in the magnificence of Jaipur’s most prestigious luxury retreat!</p>

</div></div>

</div>
</div>
</div>

<?php } else if($GLOBALS['location'][0]->slug == 'chandigarh') { ?>
<div class="container fluid-width section-space clearfix container-shadow" style="padding-top: 110px;">
<div class="row clearfix"><h2 class="sec-title align-center page-title-home">Frequently Asked Questions</h2>

<div class="frequently-questions-div">

<div class="question active">
<h5>Q:	Why is The LaLiT Chandigarh regarded as one of the best 5-star luxury hotels in Chandigarh? </h5>
<div class="arrow"></div>
<div class="answer" style="display: block;">
<p>A: The LaLiT Chandigarh is a premier 5-star luxury hotel, seamlessly blending elegant architecture, modern sophistication, and impeccable hospitality. Nestled at the foothills of the Shivalik range, this iconic hotel offers lavish accommodations, gourmet dining, a rejuvenating spa, and state-of-the-art business and event facilities. Whether you are here for business, leisure, or a grand celebration, The LaLiT Chandigarh promises an unmatched experience of comfort, style, and personalized service. </p>
</div></div>

<div class="question">
<h5>Q:	Where is The LaLiT Chandigarh located? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Strategically situated in Rajiv Gandhi IT Park, The LaLiT Chandigarh enjoys prime connectivity to both corporate hubs and major tourist attractions. It is:</p>
<ul>
<li>	22 km (40-minute drive) from Chandigarh International Airport.</li>
<li>	8.5 km (20-minute drive) from Sector 17 – Chandigarh’s commercial and shopping district.</li>
<li>	Close to key landmarks like Sukhna Lake, Rock Garden, and Elante Mall.</li>
</ul>

</div></div>

<div class="question">
<h5>Q:	What types of accommodations are available at this luxury hotel?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The hotel’s lavishly appointed rooms and suites redefine sophistication and relaxation, offering panoramic views of the Shivalik Hills and the cityscape. Options include:</p>
<ul>
<li><strong>	Deluxe Rooms –</strong> A contemporary space infused with elegant interiors and modern amenities, the deluxe room features a luxurious bedroom equipped with a writing desk, lounge chair, and a spacious bathroom.</li>
<li><strong>Premier Room –</strong> A contemporary space infused with elegant interiors and modern amenities. The forest facing premier room features a luxurious bedroom equipped with a writing desk, lounge chair, and a spacious bathroom.</li>
<li><strong>Luxury Room –</strong> Elegantly designed, Luxury Rooms are a perfect blend of luxury and comfort providing a soothing and warm ambiance.</li>
<li><strong>Executive Suite -</strong> Exuding elegance, the Executive Suite features an expansive bedroom offering splendid views of the forest with an elegantly designed dining area.</li>
<li><strong>Luxury Suites –</strong> The majestic suite allures you with its exclusive artwork, elegant décor, and rich wooden floor. Luxury Suite offers a lavish bedroom with a separate shower cubicle and bathtub, a spacious living room and dining area.</li>
<li><strong>The LaLiT Legacy Suite (Presidential Suite) –</strong> Exuding elegance, The Lalit Legacy Suite reflects understated luxury with aesthetic artifacts, contemporary furnishings, and modern amenities. It has an exquisitely designed living room, two plush bedrooms with luxurious bathrooms, a well-equipped pantry and round-the-clock butler service.</li>

</ul>

</div></div>

<div class="question">
<h5>Q:	What are the best dining options at The LaLiT Chandigarh?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The LaLiT Chandigarh offers a diverse culinary experience, with an emphasis on authentic flavors, fresh ingredients, and world-class service. Signature dining venues include:</p>
<ul>
<li><strong>	Baluchi –</strong> The hotel’s signature Pan-Indian fine-dining restaurant, renowned for its traditional Awadhi and North-Western Frontier cuisine.</li>
<li><strong>	OKO - </strong> Savour enticing oriental specialties at OKO, showcasing distinctive cuisines of South East Asia, from Japanese and Thai to Vietnamese, Mandarin and Malaysian.</li>

<li style="margin-left:2%;"><strong> 24/7 Restaurant –</strong> A multi-cuisine all-day dining experience, serving both international and local favorites.</li>
<li style="margin-left:2%;"><strong>Le Petit Café –</strong> A charming café offering gourmet coffees, artisanal teas, and delectable pastries.</li>
<li style="margin-left:2%;"><strong>The Circle Bar –</strong> A sophisticated lounge bar featuring handcrafted cocktails, premium spirits, and an elegant ambiance.</li>



</ul>

</div></div>

<div class="question">
<h5>Q:	What exclusive wellness and spa services does the hotel offer?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The Spiceology Spa at The LaLiT Chandigarh is a haven of tranquility and indulgence, offering a range of luxury wellness treatments, including:</p>

<ul>
<li>	Ayurvedic therapies and holistic healing rituals.</li>
<li>	Signature deep tissue and aromatherapy massages for complete rejuvenation.</li>
<li>	Luxury facials, detoxifying body wraps, and beauty treatments.</li>
<li>	A state-of-the-art fitness center equipped with modern workout facilities.</li>
<li>	Personalized yoga and meditation sessions for mental and physical well-being.</li>
</ul>

</div></div>

<div class="question">
<h5>Q:	What unique experiences can guests enjoy at this luxury hotel? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The LaLiT Chandigarh curates exceptional experiences, ensuring guests enjoy both relaxation and cultural immersion:</p>
<ul>
<li><strong> Heritage Walks & City Tours –</strong> Explore the rich history and architectural brilliance of Chandigarh’s iconic landmarks.</li>
<li><strong> Sunset Evenings at Sukhna Lake –</strong> Experience the serene beauty of Chandigarh’s most scenic location.</li>
<li><strong> Private Dining Experiences –</strong> Enjoy exquisite meals under the stars, specially curated by the hotel’s renowned chefs.</li>
<li><strong> Personalized Shopping Assistance –</strong> Indulge in a guided luxury shopping spree at Elante Mall or Sector 17 Plaza.</li>

</ul>

</div></div>

<div class="question">
<h5>Q:	Does The LaLiT Chandigarh offer wedding and event facilities? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Yes! The LaLiT Chandigarh is one of the most sought-after wedding and event venues in the city, featuring:</p>
<ul>
<li> Lavish banquet halls and grand outdoor venues with stunning decor.</li>
<li> Expert wedding planners to curate your dream wedding.</li>
<li> Customized gourmet catering options.</li>
<li> Cutting-edge business and conference facilities, ideal for corporate events.</li>
</ul>

</div></div>

<div class="question">
<h5>Q:	Which are the top attractions near The LaLiT Chandigarh? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Guests staying at this luxury hotel in Chandigarh have easy access to:</p>
<ul>
<li><strong>	Sukhna Lake</strong> (6 km | 12-minute drive | Taxi, Private Car)</li>
<li><strong>	Rock Garden</strong> (8 km | 15-minute drive | Taxi, Private Car)</li>
<li><strong>	Elante Mall</strong> (7 km | 15-minute drive | Taxi, Private Car)</li>
<li><strong>	Rose Garden</strong> (9.5 km | 20-minute drive | Taxi, Private Car)</li>
<li><strong>	Pinjore Gardens</strong> (17 km | 30-minute drive | Private Car)</li>

</ul>

</div></div>

<div class="question">
<h5>Q:	Does the hotel provide airport transfers and concierge services?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Absolutely! The LaLiT Chandigarh offers luxury airport transfers from Chandigarh International Airport, including:</p>
<ul>
<li>	Chauffeur-driven private car services.</li>
<li> Personalized sightseeing tours and curated itineraries.</li>

</ul>

</div></div>

<div class="question">
<h5>Q:	How can I book my stay at this 5-star luxury hotel in Chandigarh?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Guests can book their stay directly through The LaLiT Chandigarh’s official website for exclusive privileges, including:</p>
<ul>
<li>	Early booking discounts and bespoke luxury packages.</li>
<li>	Personalized concierge assistance for a tailored stay.</li>
</ul>

<p>Book your stay today and discover Chandigarh’s most exquisite luxury retreat!</p>

</div></div>

</div>
</div>
</div>

<?php } else if($GLOBALS['location'][0]->slug == 'goa') { ?>
<div class="container fluid-width section-space clearfix container-shadow" style="padding-top: 110px;">
<div class="row clearfix"><h2 class="sec-title align-center page-title-home">Frequently Asked Questions</h2>

<div class="frequently-questions-div">

<div class="question active">
<h5>Q: 	Why is The LaLiT Golf & Spa Resort Goa considered one of the best 5-star luxury hotels in Goa? </h5>
<div class="arrow"></div>
<div class="answer" style="display: block;">
<p>A: As a leading 5-star luxury hotel, The LaLiT Golf & Spa Resort Goa combines world-class amenities, breathtaking beachfront views, and signature hospitality. With opulent suites, a private golf course, gourmet dining, and a renowned spa, the resort offers an unmatched luxury experience for travelers. </p>
</div></div>

<div class="question">
<h5>Q: 	Where is this 5-star hotel located in Goa?  </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The LaLiT Golf & Spa Resort Goa is located on Rajbaga Beach, Canacona, South Goa, offering a tranquil yet luxurious escape from the busy tourist areas while remaining close to Goa’s key attractions.</p>

</div></div>

<div class="question">
<h5>Q: 	How far is the hotel from Goa International Airport?  </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: This luxury hotel in Goa is approximately:</p>
<ul>
<li>	63 km (90-minute drive) from Goa International Airport (Dabolim).</li>
<li>	90 km (2-hour drive) from Mopa Airport (North Goa). The hotel offers private luxury airport transfers for a seamless arrival experience.</li>
</ul>

</div></div> 

<div class="question">
<h5>Q: 	What are the accommodation options at this luxury hotel?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The LaLiT Golf & Spa Resort Goa offers some of the best luxury accommodations in Goa, including:</p>
<ul>
<li><strong>	Garden View Suites –</strong> Overlooking lush tropical gardens.</li>
<li><strong>	Sea View Suites –</strong> Offering panoramic views of the Arabian Sea.</li>
<li><strong>	Luxury Villas –</strong> Private and spacious, ideal for an exclusive getaway.</li>
<li><strong>	Presidential Villa –</strong> The epitome of elegance with premium amenities.</li>

</ul>

</div></div> 

<div class="question">
<h5>Q: 	What makes The LaLiT one of the best hotels for LGBTQ+ travelers?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The LaLiT Golf & Spa Resort Goa is one of the best LGBTQ+ inclusive luxury hotels, ensuring a safe, welcoming, and celebratory atmosphere for all guests. The hotel actively supports diversity and hosts LGBTQ+ events, making it a top choice for an inclusive luxury vacation.</p>
</div></div> 

<div class="question">
<h5>Q: 	What wellness and spa services do this 5-star hotel offer? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The award-winning Spiceology Spa offers a range of luxury wellness treatments, including:</p>
<ul>
<li>	Ayurvedic and aromatherapy massages for deep relaxation.</li>
<li>	Luxury facials and skin treatments for rejuvenation.</li>
<li>	Yoga and meditation sessions with expert trainers.</li>
<li>	Signature spa therapies are tailored for a holistic wellness experience.</li>
</ul>

</div></div> 

<div class="question">
<h5>Q: 	What dining options are available at this 5-star luxury hotel in Goa? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Guests can indulge in the best fine dining experiences, featuring:</p>
<ul>
<li><strong>	Canacona –</strong> All-day dining with Goan, Indian, and international cuisine.</li>
<li><strong>	Sirocco –</strong> A specialty restaurant serving fresh seafood and Mediterranean flavors.</li>
<li><strong>	Corta’s –</strong> A beachside eatery offering authentic Goan delicacies.</li>
<li><strong>	Gazebo –</strong> A poolside bar with handcrafted cocktails and gourmet snacks.</li>

</ul>

</div></div> 

<div class="question">
<h5>Q: 	What are the best activities available at this 5-star hotel? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Guests at The LaLiT Golf & Spa Resort Goa can enjoy a mix of luxury relaxation and adventure, including:</p>
<ul>
<li>	A private 9-hole championship golf course.</li>
<li>	Water sports like kayaking, jet skiing, and parasailing.</li>
<li>	Beach yoga and guided meditation sessions.</li>
<li>	Private yacht cruises and heritage excursions.</li>
</ul>

</div></div> 

<div class="question">
<h5>Q: 	Does the hotel offer luxury wedding and event services?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Yes, The LaLiT Golf & Spa Resort Goa is one of the best hotels for destination weddings and luxury events, offering:</p>
<ul>
<li>	Stunning beachfront wedding venues.</li>
<li>	Grand banquet halls and open-air event spaces.</li>
<li>	Personalized event planning and gourmet catering.</li>
<li>	Exclusive honeymoon packages for newlyweds.</li>
</ul>

</div></div> 

<div class="question">
<h5>Q: How can I book my stay at this 5-star luxury hotel in Goa? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Book directly through The LaLiT Golf & Spa Resort Goa’s official website for the best offers, including:</p>
<ul>
<li>	Early booking discounts on suites and villas.</li>
<li>	Personalized concierge services for a bespoke experience.</li>
</ul>
 

</div>
</div>
</div>

<?php } else if($GLOBALS['location'][0]->slug == 'khajuraho') { ?>
 

<?php } else if($GLOBALS['location'][0]->slug == 'kolkata') { ?>
<div class="container fluid-width section-space clearfix container-shadow" style="padding-top: 110px;">
<div class="row clearfix"><h2 class="sec-title align-center page-title-home">Frequently Asked Questions</h2>

<div class="frequently-questions-div">

<div class="question active">
<h5>Q: 	Why is The LaLiT Great Eastern Kolkata considered one of the best 5-star luxury hotels in Kolkata? </h5>
<div class="arrow"></div>
<div class="answer" style="display: block;">
<p>A: The LaLiT Great Eastern Kolkata is a legendary 5-star luxury hotel renowned for its historic grandeur, colonial-era charm, and modern sophistication. Established in 1830, this architectural masterpiece seamlessly blends heritage elegance with contemporary opulence, offering world-class accommodations, gourmet dining, and unmatched hospitality. Located in the heart of the city, it provides an indulgent retreat for business and leisure travelers, making it one of the best hotels in Kolkata. </p>
</div></div> 

<div class="question">
<h5>Q: 	Where is The LaLiT Great Eastern Kolkata located? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The LaLiT Great Eastern Kolkata enjoys a prime location in Central Kolkata, offering convenient access to iconic landmarks, business districts, and cultural attractions. Situated near Dalhousie Square, it is within proximity to major sites like Victoria Memorial, Howrah Bridge, Park Street, and the Indian Museum, making it an ideal base for exploring the city.</p>

</div></div> 

<div class="question">
<h5>Q: 	What types of accommodation are available at this 5-star hotel?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The hotel features luxurious rooms and suites designed for absolute comfort and elegance, blending colonial charm with contemporary style. Options include:</p>
<ul>
<li><strong>	Deluxe Rooms –</strong> Spacious and stylish with modern amenities.</li>
<li><strong>	Luxury Rooms –</strong> Offering refined décor and city views.</li>
<li><strong>	Heritage Suites –</strong> Featuring classic architecture, vintage furnishings, and lavish comfort.</li>
<li><strong>	The LaLiT Legacy Suite (Presidential Suite) –</strong> A grand residence with exclusive living areas, opulent décor, and personalized butler service.</li>
</ul>
</div></div> 

<div class="question">
<h5>Q: 	What are the finest dining options at this luxury hotel in Kolkata?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The LaLiT Great Eastern Kolkata offers a rich culinary experience across its diverse dining venues, each showcasing authentic flavors and global cuisines:</p>
<ul>
<li><strong> The Legacy Grill –</strong> A premium fine dining steakhouse with curated international dishes.</li>
<li><strong> Alfresco –</strong> An open-air restaurant serving global flavors in a serene ambiance.</li>
<li><strong> The Bakery –</strong> An iconic colonial-era bakery, famous for its freshly baked delicacies and artisanal pastries.</li>
<li><strong> The Tea Lounge –</strong> A perfect spot to unwind with handcrafted teas and gourmet snacks.</li>
</ul>
</div></div> 

<div class="question">
<h5>Q: 	What exclusive wellness and spa services does the hotel offer?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The Spiceology Spa at The LaLiT Great Eastern Kolkata is a haven of relaxation and rejuvenation, offering:</p>

<ul>
<li>	Signature Ayurvedic therapies for holistic well-being.</li>
<li>	Luxury massages, facials, and body treatments tailored for deep relaxation.</li>
<li>	A fully equipped fitness center with personal training options.</li>
<li>	Steam and sauna facilities for detoxification and relaxation.</li>
</ul>

</div></div> 

<div class="question">
<h5>Q: 	What unique experiences can guests enjoy at this 5-star hotel? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The hotel curates exceptional experiences that highlight Kolkata’s rich culture and history, including:</p>
<ul>
<li><strong>	Heritage Walks –</strong> Explore the hotel’s historic architecture and colonial legacy with expert-guided tours.</li>
<li><strong>	Live Cultural Performances –</strong> Enjoy traditional Bengali music and dance, offering an immersive cultural journey.</li>
<li><strong>	Private High Tea at The Bakery –</strong> Experience an exclusive afternoon tea affair, featuring handcrafted delicacies and gourmet selections.</li>
<li><strong>	Culinary Masterclasses –</strong> Engage in interactive sessions with master chefs, learning the art of Bengali and international cuisine.</li>




</ul>

</div></div> 

<div class="question">
<h5>Q: 	Does The LaLiT Great Eastern Kolkata offer wedding and event facilities? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Yes! The hotel is one of the most sought-after wedding and event venues in Kolkata, offering:</p>
<ul>
<li>	Exquisite banquet halls with colonial-era charm.</li>
<li>	Bespoke wedding planning and customized catering services.</li>
<li>	State-of-the-art conference rooms for business events and corporate gatherings.</li>
</ul>

</div></div> 

<div class="question">
<h5>Q: 	Which are the top attractions near The LaLiT Great Eastern Kolkata? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Guests staying at this 5-star luxury hotel in Kolkata can easily explore:</p>
<ul>
<li><strong>	Victoria Memorial</strong> (3 km | 10-minute drive | Taxi, Private Car)</li>
<li><strong>	Howrah Bridge</strong> (2 km | 8-minute drive | Taxi, Private Car)</li>
<li><strong>	Park Street</strong> (2.5 km | 10-minute drive | Taxi, Tuk-Tuk)</li>
<li><strong>	Indian Museum</strong> (2 km | 7-minute drive | Taxi, Tuk-Tuk)</li>
<li><strong>	Eden Gardens</strong> (1.5 km | 5-minute drive | Taxi, Private Car)</li>
<li><strong>	Kumartuli</strong> (Artisan Quarter) (5 km | 15-minute drive | Taxi, Private Car)</li>
</ul>

</div></div> 

<div class="question">
<h5>Q: 	Does the hotel provide airport transfers and concierge services?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Yes, the hotel offers luxury airport transfers from Netaji Subhas Chandra Bose International Airport (17 km | 40-minute drive). Guests can opt for:</p>
<ul>
<li>	Chauffeur-driven luxury cars for a seamless arrival experience.</li>
<li>	Private sightseeing tours and itinerary planning by the concierge team.</li>
</ul>

</div></div> 

<div class="question">
<h5>Q: 	How can I book my stay at this luxury hotel in Kolkata?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Guests can book directly through The LaLiT Great Eastern Kolkata’s official website for exclusive offers and privileges, including:</p>
<ul>
<li>	Early booking discounts and luxury stay packages.</li>
<li>	Personalized concierge assistance for a truly bespoke stay.</li>
</ul>

<p style="padding-top:15px;">Book your stay today and immerse yourself in the grandeur of Kolkata’s most iconic luxury hotel!</p>

</div></div> 

</div>
</div>
</div>

<?php } else if($GLOBALS['location'][0]->slug == 'mangar') { ?>
 

<?php } else if($GLOBALS['location'][0]->slug == 'srinagar') { ?>
 

<?php } elseif($GLOBALS['location'][0]->slug == 'udaipur') { ?>


<div class="container fluid-width section-space clearfix container-shadow" style="padding-top: 110px;">
<div class="row clearfix"><h2 class="sec-title align-center page-title-home">Frequently Asked Questions</h2>

<div class="frequently-questions-div">

<div class="question active">
<h5>Q:	Why is The LaLiT Laxmi Vilas Palace Udaipur regarded as one of the best 5-star luxury hotels in Udaipur? </h5>
<div class="arrow"></div>
<div class="answer" style="display: block;">
<p>A: Perched majestically on a hilltop overlooking the pristine Fateh Sagar Lake, The LaLiT Laxmi Vilas Palace Udaipur is a royal heritage hotel that embodies the grandeur of Rajasthan’s regal past while offering modern 5-star luxury. Originally built in 1911 by Maharana Fateh Singh, this architectural masterpiece boasts opulent suites, world-class hospitality, gourmet dining, and curated cultural experiences, making it one of the best luxury hotels in Udaipur for travelers seeking elegance, exclusivity, and an unforgettable stay. </p>
</div></div>

<div class="question">
<h5>Q:	Where is The LaLiT Laxmi Vilas Palace Udaipur located? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: This iconic 5-star heritage hotel is beautifully located on a scenic hilltop along Fateh Sagar Lake, offering breathtaking panoramic views of the Aravalli Hills and Udaipur’s royal cityscape. The hotel’s prime location ensures that guests are within easy reach of Udaipur’s top attractions, such as City Palace, Lake Pichola, and Sajjangarh Fort, making it a perfect retreat for luxury seekers.</p>

</div></div>

<div class="question">
<h5>Q:	What types of accommodations are available at this luxury hotel?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The accommodations at The LaLiT Laxmi Vilas Palace Udaipur redefine heritage luxury, offering guests an indulgent blend of Rajasthani royal charm and contemporary comfort. Each room and suite is thoughtfully designed to immerse guests in the elegance of a bygone era, featuring intricate woodwork, vintage decor, and plush modern amenities. Options include:</p>
<ul>
<li><strong>	Palace Rooms –</strong> Perfect for guests seeking classic luxury with picturesque views.</li>
<li><strong>	Heritage Suites –</strong> Elegantly designed with expansive living spaces and regal furnishings.</li>
<li><strong>	Maharana Suite –</strong> The epitome of royal indulgence, offering a private terrace with breathtaking lake views, a grand bedroom, and dedicated butler service.</li>

</ul>

</div></div>

<div class="question">
<h5>Q:	What are the finest dining options at this 5-star luxury hotel in Udaipur?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The LaLiT Laxmi Vilas Palace Udaipur offers a gastronomic experience fit for royalty, featuring the finest local and global cuisines prepared by expert chefs in an ambiance of unmatched grandeur. Dining options include:</p>
<ul>
<li><strong> Aangan –</strong> A signature fine dining experience with authentic Rajasthani flavors, complemented by mesmerizing views of Fateh Sagar Lake.</li>
<li><strong> Padmini –</strong> A multi-cuisine all-day dining restaurant, offering a fusion of Indian and international delicacies.</li>
<li><strong> The Garden Grill –</strong> A romantic al fresco dining experience, featuring succulent grilled specialties under a starlit sky.</li>

</ul>

</div></div>

<div class="question">
<h5>Q:	What exclusive wellness and spa services are available at the hotel?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Guests can embark on a holistic wellness journey at the Spiceology Spa, which offers a curated selection of rejuvenating treatments inspired by ancient Ayurvedic and contemporary healing techniques. Signature offerings include:</p>

<ul>
<li>	Traditional Ayurvedic therapies to restore balance and harmony.</li>
<li>	Deep tissue and Swedish massages for complete relaxation.</li>
<li>	Exclusive wellness rituals and beauty therapies for a luxurious spa experience.</li>
<li> Additionally, the hotel features a fully equipped fitness center and serene yoga sessions amidst the picturesque palace gardens.</li>
</ul>

</div></div>

<div class="question">
<h5>Q:	What unique experiences and activities can guests enjoy at this 5-star hotel? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: The LaLiT Laxmi Vilas Palace Udaipur offers bespoke experiences that provide guests with an authentic taste of Rajasthan’s cultural and royal heritage, including:</p>
<ul>
<li><strong>	Heritage Walks –</strong> Explore the rich history and regal architecture of the palace with a guided tour.</li>
<li><strong>	Live Cultural Performances –</strong> Experience traditional Rajasthani folk music and dance, including the mesmerizing Kathputli (puppet) dance, a centuries-old storytelling art form unique to Rajasthan.</li>
<li><strong>	Sunset Boat Rides on Fateh Sagar Lake –</strong> Witness the golden hues of Udaipur’s sunset as you glide across the tranquil waters, with the majestic Aravalli Hills and grand palaces creating a breathtaking backdrop.</li>
<li><strong>	Private Royal Dining Experiences –</strong> Savor an exclusive candlelit dinner under the stars, set against the enchanting views of Fateh Sagar Lake and Udaipur’s skyline, with curated gourmet delicacies crafted by expert chefs.</li>



</ul>

</div></div>

<div class="question">
<h5>Q:	Is The LaLiT Laxmi Vilas Palace Udaipur a preferred wedding and event destination? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Absolutely! Recognized as one of the most sought-after destination wedding venues in Udaipur, the palace offers a storybook setting for regal celebrations. The hotel’s stunning venues and expert event planning services make it ideal for weddings, corporate gatherings, and milestone celebrations. Highlights include:</p>
<ul>
<li>	Enchanting outdoor wedding venues with panoramic views.</li>
<li>	Lavish banquet halls and heritage courtyards for grand celebrations.</li>
<li>	Custom wedding planning, curated gourmet menus, and luxury bridal suites.</li>
</ul>

</div></div>

<div class="question">
<h5>Q:	Which are the top nearby attractions to explore from this luxury hotel? </h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Staying at this 5-star heritage hotel in Udaipur provides easy access to some of the city’s most iconic landmarks, including:</p>
<ul>
<li><strong>	City Palace</strong> (4 km | 10-minute drive | Taxi, Private Car)</li>
<li><strong>	Lake Pichola </strong>(5 km | 12-minute drive | Boat Ride, Taxi)</li>
<li><strong>	Jagdish Temple</strong> (4 km | 10-minute drive | Taxi, Tuk-Tuk)</li>
<li><strong>	Saheliyon Ki Bari</strong> (2 km | 5-minute drive | Taxi, Tuk-Tuk)</li>
<li><strong>	Monsoon Palace</strong> (Sajjangarh Fort) (8 km | 20-minute drive | Private Car)</li>
<li><strong>	Bagore Ki Haveli</strong> (5 km | 12-minute drive | Taxi, Tuk-Tuk)</li>
<li><strong>	Shilpgram</strong> (Rajasthani Handicraft Village) (4 km | 10-minute drive | Taxi, Private Car)</li>
<li><strong>	Fateh Prakash Palace Museum</strong> (3 km | 8-minute drive | Taxi, Tuk-Tuk)</li>


</ul>

</div></div>

<div class="question">
<h5>Q:	Does The LaLiT Laxmi Vilas Palace Udaipur provide airport transfers and concierge services?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Yes! The hotel offers luxury airport transfers from Maharana Pratap Airport (27 km | 40-minute drive). Guests can choose from:</p>
<ul>
<li>	Private luxury car service with a chauffeur.</li>
<li>	Airport shuttle service upon request.</li>
<li>	Concierge-assisted personalized sightseeing tours.</li>
</ul>

</div></div>

<div class="question">
<h5>Q:	How can I book my stay at this 5-star luxury hotel in Udaipur?</h5>
			<div class="arrow"></div>
<div class="answer">
<p>A: Guests can book their stay directly through The LaLiT Laxmi Vilas Palace Udaipur’s official website or through premium travel partners. Exclusive benefits include:</p>
<ul>
<li>	Early booking discounts and tailored luxury packages.</li>
<li>	Personalized itinerary planning for an unmatched experience.</li>
</ul>

<p style="padding-top:15px;">Book your stay today and immerse yourself in the regal splendor of Rajasthan’s most luxurious palace hotel!</p>

</div></div>

</div>
</div>
</div>


<?php }  */   ?>
<?php //echo $GLOBALS['location'][0]->slug; ?>
 

         <?php get_footer(); ?>
      </div>
      <script type="text/javascript">
        
        
        jQuery(window).load(function(){

            jQuery('body').css('overflow-x','hidden');
            
            jQuery(window).on('resize', function(){

               jQuery('.awardsSlider').resize();
            });
         });
	      var is_iPad = navigator.userAgent.match(/iPad/i) != null;
        var ismobile =navigator.userAgent.match(/(iPod)|(iPhone)|(android)|(webOS)|(blackbery)/i) != null;
         
         var service_images = <?php echo json_encode($GLOBALS['hotel_service_image']); ?>;
         var banner_images = <?php echo json_encode($GLOBALS['banner_images']); ?>;

         var hotel_name = <?php echo json_encode($GLOBALS['hotel_name']); ?>;
         var hotel_address = <?php echo json_encode($GLOBALS['address']); ?>;
         var hotel_email = <?php echo json_encode($GLOBALS['email']); ?>;
         var hotel_image = <?php echo json_encode($GLOBALS['hotel_image']); ?>;
         var hotel_phone = <?php echo json_encode($GLOBALS['phone']); ?>;
         var hotel_fax = <?php echo json_encode($GLOBALS['fax']); ?>;

         if(jQuery(window).width() >= 768){
            
        	if(!is_iPad && jQuery('.awardsSlider .slides li').length > 4){
            	jQuery('.awardsSlider').flexslider({
               		animation: "slide",
               		animationLoop: true,
               		pauseOnAction: true,
               		pauseOnHover: true,
               		itemWidth: 400,      
               		minItems: getGridSize(),
               		maxItems: getGridSize(),
               		itemMargin: 60,
               		slideshowSpeed: 7000,
               		controlNav: true,
               		directionNav: true,
               		move: 4,
            	});
        	}
        	else if(is_iPad && jQuery('.awardsSlider .slides li').length > 3){
        		jQuery('.awardsSlider').flexslider({
               		animation: "slide",
               		animationLoop: true,
               		pauseOnAction: true,
               		pauseOnHover: true,
               		itemWidth: 400,      
               		minItems: getGridSize(),
               		maxItems: getGridSize(),
               		itemMargin: 60,
               		slideshowSpeed: 7000,
               		controlNav: true,
               		directionNav: true,
               		move: 4,
            	});
        	}
         }
         else{
			if(jQuery('.awardsSlider .slides li').length > 1){
            	jQuery('.awardsSlider').flexslider({
               		animation: "slide",
               		animationLoop: true,
               		pauseOnAction: true,
               		pauseOnHover: true,
               		controlNav: true,
               		slideshowSpeed: 7000,
            	});
            }
         }

         function getGridSize() {
      		return (window.innerWidth < 767) ? 1 : (window.innerWidth < 992) ? 3 : 4;
    	}

      </script>
      <script src="<?php echo get_stylesheet_directory_uri(); ?>/js/hotel-overview.min.js" async></script>
	   <!-- Sojern Container Tag cp_v1_js, Pixel Version: 1 -->
<script>
(function () {
/* Please fill the following values. */
var params = {
hpid: "76565", /* Property ID */
pt: "HOME_PAGE" /* Page Type - HOME_PAGE or PRODUCT or TRACKING */
};
/* Please do not modify the below code. */
var paramsArr = [];
for(key in params) { paramsArr.push(key + '=' + encodeURIComponent(params[key])) };
var pl = document.createElement('script');
pl.type = 'text/javascript';
pl.async = true;
pl.src = "https://beacon.sojern.com/pixel/cp/11?f_v=cp_v1_js&p_v=1&" + paramsArr.join('&');
(document.getElementsByTagName('head')[0] || document.getElementsByTagName('body')
[0]).appendChild(pl);
})();
</script>
<!-- End Sojern Tag -->
<!-- Sojern Container Tag cp_v1_js, Pixel Version: 1 -->
<script>
(function () {
/* Please fill the following values. */
var params = {
hpid: "76565", /* Property ID */
pt: "TRACKING" /* Page Type - HOME_PAGE or PRODUCT or TRACKING */
};
/* Please do not modify the below code. */
var paramsArr = [];
for(key in params) { paramsArr.push(key + '=' + encodeURIComponent(params[key])) };
var pl = document.createElement('script');
pl.type = 'text/javascript';
pl.async = true;
pl.src = "https://beacon.sojern.com/pixel/cp/11?f_v=cp_v1_js&p_v=1&" + paramsArr.join('&');
(document.getElementsByTagName('head')[0] || document.getElementsByTagName('body')
[0]).appendChild(pl);
})();
</script>
<!-- End Sojern Tag -->	   
	   
<!---poup js-->  
<script src="https://thelalit.com/script-top-off.js"></script>
<!---poup js end--> 



   </body>
</html>
